/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;

public class BlockJellyfishMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape TOP_SHAPE = BlockJellyfishMushroom.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockJellyfishMushroom.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    public static final EnumProperty<BNBlockProperties.JellyShape> VISUAL = BNBlockProperties.JELLY_MUSHROOM_VISUAL;

    public BlockJellyfishMushroom() {
        super(Materials.makeNetherWood(MapColor.f_283772_).m_60953_(s -> 13).m_155954_(0.1f).m_60918_(SoundType.f_56711_).m_60978_(1.0f).m_60955_());
        boolean sodium = FabricLoader.getInstance().isModLoaded("sodium");
        this.setRenderLayer(sodium ? BNRenderLayer.CUTOUT : BNRenderLayer.TRANSLUCENT);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE, VISUAL});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.m_61143_(SHAPE) == BlockProperties.TripleShape.TOP ? TOP_SHAPE : MIDDLE_SHAPE;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.JELLYFISH_MUSHROOM_SAPLING);
    }

    @Environment(value=EnvType.CLIENT)
    public float m_7749_(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter view, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        switch ((BlockProperties.TripleShape)state.m_61143_(SHAPE)) {
            case BOTTOM: {
                return world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) ? state : Blocks.f_50016_.m_49966_();
            }
            case MIDDLE: {
                return world.m_8055_(pos.m_7494_()).m_60734_() == this && world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) ? state : Blocks.f_50016_.m_49966_();
            }
        }
        return world.m_8055_(pos.m_7495_()).m_60734_() == this ? state : Blocks.f_50016_.m_49966_();
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (world.m_8055_(pos).m_61143_(SHAPE) != BlockProperties.TripleShape.TOP) {
            return;
        }
        if (entity.m_20162_()) {
            super.m_142072_(world, state, pos, entity, fallDistance);
        } else {
            entity.m_142535_(fallDistance, 0.0f, world.m_269111_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter world, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(world, entity);
        } else {
            this.bounce(entity);
        }
    }

    private void bounce(Entity entity) {
        Vec3 vec3d = entity.m_20184_();
        if (vec3d.f_82480_ < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3d.f_82479_, -vec3d.f_82480_ * d, vec3d.f_82481_);
        }
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (world.m_8055_(pos).m_61143_(SHAPE) != BlockProperties.TripleShape.TOP) {
            super.m_141947_(world, pos, state, entity);
            return;
        }
        double d = Math.abs(entity.m_20184_().f_82480_);
        if (d < 0.1 && !entity.m_20161_()) {
            double e = 0.4 + d * 0.2;
            entity.m_20256_(entity.m_20184_().m_82542_(e, 1.0, e));
        }
        super.m_141947_(world, pos, state, entity);
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (state.m_61143_(SHAPE) == BlockProperties.TripleShape.TOP) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.JELLYFISH_MUSHROOM_SAPLING, MHelper.randRange(1, 2, MHelper.RANDOM)), new ItemStack((ItemLike)NetherItems.GLOWSTONE_PILE, MHelper.randRange(0, 2, MHelper.RANDOM)), new ItemStack((ItemLike)Items.f_42518_, MHelper.randRange(0, 1, MHelper.RANDOM))});
        }
        if (state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.JELLYFISH_MUSHROOM_SAPLING, MHelper.randRange(1, 2, MHelper.RANDOM))});
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
    }
}

